(function (wp) {
    /**
     * Registers a new block provided a unique name and an object defining its behavior.
     * @see https://wordpress.org/gutenberg/handbook/designers-developers/developers/block-api/#registering-a-block
     */
    var registerBlockType = wp.blocks.registerBlockType;
    /**
     * Returns a new element of given type. Element is an abstraction layer atop React.
     * @see https://wordpress.org/gutenberg/handbook/designers-developers/developers/packages/packages-element/
     */
    var el = wp.element.createElement;
    /**
     * Retrieves the translation of text.
     * @see https://wordpress.org/gutenberg/handbook/designers-developers/developers/packages/packages-i18n/
     */
    var __ = wp.i18n.__;

    var InspectorControls = wp.editor.InspectorControls;
    var TextControl = wp.components.TextControl;

    function MsfControl(props) {
        var attributes = props.attributes;
        var setAttributes = props.setAttributes;

        var id = attributes.id === null ? 0 : attributes.id;

        var inspectorControl = el(InspectorControls, {},
            el('h4', {}, el('span', {}, __('Multi Step Form'))),
            el(TextControl, {
                label: __('Form ID'),
                value: id,
                type: 'number',
                onChange: function (value) {
                    setAttributes({ id: value });
                }
            }),
        );
        return el('div', {
            className: 'msf-block'
        },
            el('h4', { }, __('Multi Step Form')),
            el('p', { }, __('Form ID') + ': ' + id),
            inspectorControl
        );
    }

    /**
     * Every block starts by registering a new block type definition.
     * @see https://wordpress.org/gutenberg/handbook/designers-developers/developers/block-api/#registering-a-block
     */
    registerBlockType('multi-step-form/msf', {
        /**
         * This is the display title for your block, which can be translated with `i18n` functions.
         * The block inserter will show this name.
         */
        title: __('Multi Step Form'),

        /**
         * Blocks are grouped into categories to help users browse and discover them.
         * The categories provided by core are `common`, `embed`, `formatting`, `layout` and `widgets`.
         */
        category: 'widgets',

        /**
         * The same icon as the MSF menu.
         */
        icon: 'feedback',

        /**
         * Optional block extended support features.
         */
        supports: {
            // Removes support for an HTML mode.
            html: false,
        },

        attributes: {
            id: {
                type: 'string',
                default: null
            }
        },

        /**
         * The edit function describes the structure of your block in the context of the editor.
         * This represents what the editor will render when the block is used.
         * @see https://wordpress.org/gutenberg/handbook/designers-developers/developers/block-api/block-edit-save/#edit
         *
         * @param {Object} [props] Properties passed from the editor.
         * @return {Element}       Element to render.
         */
        edit: MsfControl,

        /**
         * The save function defines the way in which the different attributes should be combined
         * into the final markup, which is then serialized by Gutenberg into `post_content`.
         * @see https://wordpress.org/gutenberg/handbook/designers-developers/developers/block-api/block-edit-save/#save
         *
         * @return {Element}       Element to render.
         */
        save: function () {
            return null;
        }
    });
})(
    window.wp
);
